﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using PpmsDataService.Models;
using PpmsDataService.ModelsEnumTypes;

namespace PpmsDataService.Models
{
    public class VaProviderRelationship
    {
        [Key]
        public string Name { get; set; }

        public RelationshipType RelationshipType { get; set; }

        public string ProviderName { get; set; }

        public string CareSiteName { get; set; }

        public string CredentialName { get; set; }

        public string ProviderNetworkName { get; set; }

        public DateTime? StartDate { get; set; }

        public DateTime? EndDate { get; set; }

        //Single
        public virtual IQueryable<Provider> Provider { get; set; }

        //Single
        public virtual IQueryable<CareSite> CareSite { get; set; }

        //Single
        public virtual IQueryable<ProviderCredential> Credentialing { get; set; }

        //Single
        public virtual IQueryable<ProviderNetwork> ProviderNetwork { get; set; }

        //Many
        public virtual IQueryable<AgreementProvider> AgreementProviders { get; set; }

        //Many
        public virtual IQueryable<ProviderService> ProviderServices { get; set; }

    }
}